package edu.uky.ai.ml.nn;

import java.util.ArrayList;
import java.util.Random;

/**
 * A layer is a collection of neurons in a neural network.  There are two
 * special layers: the input and output layers.  All other layers are called
 * hidden layers.  Traditionally, all neurons at layer i are connected to
 * all neurons at layer i + 1.
 * 
 * @author Stephen G. Ware
 */
public class Layer {

	/** The neurons in this layer */
	public final Neuron[] neurons;
	
	/** The layer immediately before this layer */
	public final Layer previous;
	
	/**
	 * Constructs a new layer.
	 * 
	 * @param network the neural network to which this layer belongs
	 * @param previous the previous layer
	 * @param neurons the number of neurons to create in this layer
	 * @param random a random number generator for setting the initial edge weights
	 */
	Layer(NeuralNetwork network, Layer previous, int neurons, Random random) {
		this.neurons = new Neuron[neurons];
		this.previous = previous;
		for(int i=0; i<neurons; i++) {
			Neuron child = previous == null ? new InputNeuron() : new Neuron();
			this.neurons[i] = child;
			if(previous != null)
				for(Neuron parent : previous.neurons)
					((ArrayList<Edge>) network.edges).add(new Edge(parent, random, child));
		}
	}
}
